/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8260;

import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.MessageDestination;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.NavigationBrowser;
import ibm.nways.jdm.NavigationBrowserEventListener;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationItem;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.browser.Browser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmContext;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel;
import ibm.nways.jdm.eui.BoxDownMsg;
import ibm.nways.jdm.eui.MessageBox;
import ibm.nways.jdm.eui.WrongSysOidMsg;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.jdm8260.Agent8250;
import ibm.nways.jdm8260.Agent8260;
import ibm.nways.jdm8260.AgentCPSW;
import ibm.nways.jdm8260.DeviceView.Builder;
import ibm.nways.jdm8260.DeviceView.Hub;
import ibm.nways.jdm8260.DeviceView.HubInfoLike;
import ibm.nways.jdm8260.DeviceView.HubLike;
import ibm.nways.jdm8260.Jdm8260NicknameTable;
import ibm.nways.jdm8260.Jdm8260SummaryInfo;
import ibm.nways.jdm8260.MibInfo;
import ibm.nways.jdm8260.SummaryInfoLike;
import ibm.nways.jdm8260.eui.ConfigurationFolderGroup;
import ibm.nways.jdm8260.eui.FaultGroup;
import ibm.nways.jdm8260.eui.Jdm8260Group;
import ibm.nways.jdm8260.eui.SecurityGroup;
import ibm.nways.mib2.SystemGeneralGroup;
import ibm.nways.ras.RAS;
import ibm.nways.rmon.RmonContext;
import ibm.nways.telnet.TelnetContext;
import ibm.nways.web.WebContext;
import java.applet.Applet;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class Jdm8260
extends JdmBrowser {
    public String sysOid;
    public int hubType;
    private boolean isDeviceUp = false;
    private NavigationFolder rootFolder;
    private NavigationBrowser tree;
    private ResourceBundle resBundle = ResourceBundle.getBundle("ibm.nways.jdm8260.Resources");
    private GenModel jdm8260Model;
    private HubLike hub;
    private MibInfo mibInfo;
    private String ipAddress;
    private SummaryInfoLike summaryInfo;

    public String getModelTypeName() {
        return "ibm.nways.jdm8260.model.Jdm8260";
    }

    public void dispose() {
        this.tree = null;
        this.rootFolder = null;
        this.jdm8260Model = null;
        if (this.mibInfo != null) {
            this.mibInfo.dispose();
        }
        this.mibInfo = null;
        if (this.summaryInfo != null) {
            this.summaryInfo.dispose();
        }
        this.summaryInfo = null;
        if (this.hub != null) {
            this.hub.dispose();
        }
        this.hub = null;
        super.dispose();
    }

    public GraphicPanel getDeviceGraphicPanel() {
        int n;
        Serializable serializable;
        Object[] objectArray;
        Object object;
        String string = "getDeviceGraphicPanel";
        if (RAS.isEnabled(19, 2)) {
            RAS.enter(19, 2, (Object)this, string);
        }
        try {
            SnmpContextModel snmpContextModel = (SnmpContextModel)this.jdm8260Model.getComponent("_ContextInfo");
            object = snmpContextModel.getConfig();
            this.ipAddress = ((ModelInfo)object).get("Config.Address").toString();
        }
        catch (Exception exception) {
            RAS.logException(19, 2, (Object)this, string, exception);
        }
        boolean bl = true;
        try {
            object = (GenModel)this.jdm8260Model.getComponent("QuickAgents");
            Vector vector = object.getRestOfInfo("Panel", "default", null, null);
            Vector<Object[]> vector2 = new Vector<Object[]>();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ModelInfo modelInfo = (ModelInfo)enumeration.nextElement();
                objectArray = modelInfo.get("Panel.AgentsIpAddress").toString();
                serializable = (Integer)modelInfo.get("Panel.AgentsMasterStatus");
                Integer n2 = (Integer)modelInfo.get("Panel.AgentsMasterPriority");
                if (objectArray.equals(this.ipAddress)) {
                    if ((Integer)serializable == 1) continue;
                    bl = false;
                    this.isDeviceUp = false;
                    continue;
                }
                if (n2 == 11) continue;
                vector2.addElement(objectArray);
            }
            try {
                this.jdm8260Model.addBackupAddresses(vector2);
            }
            catch (Exception exception) {
                RAS.logException(19, 2, (Object)this, string, exception);
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 2, (Object)this, string, exception);
        }
        if (!bl) {
            new MessageBox(this.getFrame(), this.resBundle.getString("NonMasterTitle"), this.resBundle.getString("NonMasterMessage"), true);
        }
        long l = System.currentTimeMillis();
        this.displayMsg(this.resBundle.getString("retrieving_sst"));
        if (this.summaryInfo == null) {
            this.summaryInfo = new Jdm8260SummaryInfo();
        }
        this.mibInfo.clearSummaryInfo();
        this.mibInfo.setSummaryInfo(this.summaryInfo);
        long l2 = System.currentTimeMillis();
        if (RAS.isEnabled(19, 2)) {
            RAS.trace(19, 2, (Object)this, string, "Time to retrieve summary table -> " + (l2 - l));
        }
        if (this.mibInfo.getErrorStatus()) {
            int n3 = this.mibInfo.getErrorCode();
            if (RAS.isEnabled(19, 2)) {
                RAS.trace(19, 2, (Object)this, string, "MibInfo RC: " + n3);
            }
            switch (n3) {
                case 1: {
                    new BoxDownMsg(this.getFrame(), this.resBundle.getString("hubs_jma"));
                    break;
                }
                case 2: {
                    new WrongSysOidMsg(this.getFrame(), this.resBundle.getString("hubs_jma"));
                    break;
                }
                case 4: {
                    new MessageBox(this.getFrame(), this.resBundle.getString("summary_timeout_title"), this.resBundle.getString("summary_timeout"), false);
                    break;
                }
                default: {
                    if (!RAS.isEnabled(19, 2)) break;
                    RAS.trace(19, 2, (Object)this, string, "Unknown MibInfo error code:" + n3);
                }
            }
            if (n3 != 3 && n3 != 4) {
                this.sysOid = null;
                this.isDeviceUp = false;
            }
        }
        if (this.sysOid != null && this.sysOid.equals("1.3.6.1.4.1.49.2.3.12") && (n = ((Jdm8260SummaryInfo)this.summaryInfo).getDMMVersion()) < 3) {
            objectArray = new Object[]{new Integer(n)};
            serializable = new I18NMsgFormat("ibm.nways.jdm8260.Resources", "dmm_version", objectArray);
            new MessageBox(this.getFrame(), this.resBundle.getString("warning_title"), ((I18NString)serializable).getTranslation(), false);
        }
        this.displayMsg(this.resBundle.getString("building_graphic"));
        l = System.currentTimeMillis();
        if (this.hub != null) {
            ((HubInfoLike)((Object)this.hub)).stopThreads();
            this.hub.dispose();
            this.hub = null;
        }
        this.hub = Builder.getInstance().buildHub(this, this.mibInfo);
        l2 = System.currentTimeMillis();
        if (RAS.isEnabled(19, 2)) {
            RAS.trace(19, 2, (Object)this, string, "Time building -> " + (l2 - l));
        }
        l = System.currentTimeMillis();
        this.hub.draw();
        l2 = System.currentTimeMillis();
        if (RAS.isEnabled(19, 2)) {
            RAS.trace(19, 2, (Object)this, string, "Time to draw -> " + (l2 - l));
        }
        GraphicPanel graphicPanel = this.hub.getGraphicPanel();
        this.hub.addLaunchContext(this.rootFolder.getNavContext());
        if (RAS.isEnabled(19, 2)) {
            RAS.exit(19, 2, (Object)this, string);
        }
        return graphicPanel;
    }

    protected NavigationPoint getNavTreeRoot() {
        Object object;
        String string = "getNavTreeRoot";
        String string2 = null;
        String string3 = ((Applet)((Object)this)).getParameter("trace_jma");
        String string4 = ((Applet)((Object)this)).getParameter("trace_decoder");
        if (string3 != null && string3.equals("on")) {
            RAS.enableTrcLog(19, 2);
        }
        if (string4 != null && string4.equals("on")) {
            RAS.enableTrcLog(19, 2);
        }
        if (this.mibInfo == null) {
            this.mibInfo = new MibInfo();
        }
        this.jdm8260Model = (GenModel)this.getModel();
        this.hubType = this.getHubModel();
        this.displayMsg(this.resBundle.getString("start"));
        this.isDeviceUp = true;
        switch (this.hubType) {
            case 0: {
                string2 = this.resBundle.getString("8250_Root_Folder");
                break;
            }
            case 1: {
                string2 = this.resBundle.getString("8260_Root_Folder");
                break;
            }
            case 2: {
                string2 = this.resBundle.getString("8265_Root_Folder");
                break;
            }
            default: {
                string2 = this.resBundle.getString("Unknown_Hub_Root_Folder");
                this.isDeviceUp = false;
            }
        }
        try {
            object = (GenModel)this.jdm8260Model.getComponent("ConcScalars");
            if (object == null) {
                this.isDeviceUp = false;
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 2, (Object)this, string, exception);
        }
        if (this.isDeviceUp) {
            this.rootFolder = new Jdm8260Group((JdmBrowser)this, this.jdm8260Model);
            this.rootFolder.setLabel(string2);
        } else {
            this.rootFolder = new NavigationFolder(string2);
        }
        if (this.isDeviceUp) {
            object = "";
            Serializable serializable = this.mibInfo.getVar("sysDescr");
            if (serializable instanceof String) {
                object = serializable.toString();
            }
            NavigationContext navigationContext = this.rootFolder.getNavContext();
            switch (this.hubType) {
                case 0: {
                    new NavFieldOverride(navigationContext, Agent8250.getOverrides());
                    break;
                }
                case 2: {
                    NavFieldOverride navFieldOverride = new NavFieldOverride(navigationContext, AgentCPSW.getOverrides());
                    AgentCPSW.addOtherOverrides((String)object, navFieldOverride);
                    break;
                }
                case 1: {
                    if (this.sysOid == null) break;
                    if (this.sysOid.equals("1.3.6.1.4.1.2.6.33.2.1")) {
                        NavFieldOverride navFieldOverride = new NavFieldOverride(navigationContext, AgentCPSW.getOverrides());
                        AgentCPSW.addOtherOverrides((String)object, navFieldOverride);
                        break;
                    }
                    new NavFieldOverride(navigationContext, Agent8260.getOverrides());
                    break;
                }
                default: {
                    if (!RAS.isEnabled(19, 2)) break;
                    RAS.trace(19, 2, (Object)this, string, "Unknown HUB Model: no overrides added");
                }
            }
        }
        return this.rootFolder;
    }

    protected void getRestOfNavTree() {
        this.displayMsg(this.resBundle.getString("start_rest"));
        NavigationFolder navigationFolder = (NavigationFolder)this.getNavigationTree();
        this.tree = this.getNavigationBrowser();
        NavigationContext navigationContext = this.rootFolder.getNavContext();
        navigationContext.put((Object)"TREE", (Object)this.tree);
        int[] nArray = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1};
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        RmonContext rmonContext = new RmonContext(nArray, nArray2, nArray3);
        navigationContext.put((Object)"rmonContext", (Object)rmonContext);
        this.buildConfigurationFolder(navigationFolder);
        this.buildFaultFolder(navigationFolder);
        this.buildSecurityFolder(navigationFolder);
        this.buildToolsFolder(navigationFolder);
        this.displayMsg(this.resBundle.getString("done"));
        if (this.hub != null) {
            ((HubInfoLike)((Object)this.hub)).startThreads();
        }
    }

    private void buildConfigurationFolder(NavigationFolder navigationFolder) {
        String string = "buildConfigurationFolder";
        GenModel genModel = null;
        try {
            genModel = (GenModel)this.jdm8260Model.getComponent("ConfigurationFolder");
        }
        catch (Exception exception) {
            RAS.logException(19, 2, (Object)this, string, exception);
        }
        if (genModel == null || !this.isDeviceUp) {
            GenModel genModel2 = null;
            try {
                genModel2 = (GenModel)this.jdm8260Model.getComponent("System");
            }
            catch (Exception exception) {
                RAS.logException(19, 2, (Object)this, string, exception);
            }
            if (genModel2 != null) {
                SystemGeneralGroup systemGeneralGroup = new SystemGeneralGroup((JdmBrowser)this, genModel2);
                systemGeneralGroup.setIsInitiallyExpanded(false);
                this.tree.addEventListener((NavigationBrowserEventListener)systemGeneralGroup);
                navigationFolder.add((NavigationPoint)systemGeneralGroup);
                return;
            }
        } else {
            ConfigurationFolderGroup configurationFolderGroup = new ConfigurationFolderGroup((JdmBrowser)this, genModel);
            configurationFolderGroup.setIsInitiallyExpanded(false);
            this.tree.addEventListener((NavigationBrowserEventListener)configurationFolderGroup);
            navigationFolder.add((NavigationPoint)configurationFolderGroup);
        }
    }

    private void buildFaultFolder(NavigationFolder navigationFolder) {
        String string = "buildFaultFolder";
        GenModel genModel = null;
        try {
            genModel = (GenModel)this.jdm8260Model.getComponent("Traps");
        }
        catch (Exception exception) {
            RAS.logException(19, 2, (Object)this, string, exception);
        }
        if (genModel != null) {
            FaultGroup faultGroup = new FaultGroup((JdmBrowser)this, this.jdm8260Model);
            faultGroup.setIsInitiallyExpanded(false);
            this.tree.addEventListener((NavigationBrowserEventListener)faultGroup);
            navigationFolder.add((NavigationPoint)faultGroup);
            return;
        }
        navigationFolder.add((NavigationPoint)new NavigationItem(this.resBundle.getString("FaultFolder"), (NavigationDestination)new MessageDestination(this.resBundle.getString("not_configured"))));
    }

    private void buildSecurityFolder(NavigationFolder navigationFolder) {
        String string = "buildSecurityFolder";
        GenModel genModel = null;
        try {
            genModel = (GenModel)this.jdm8260Model.getComponent("SecurityFolder");
        }
        catch (Exception exception) {
            RAS.logException(19, 2, (Object)this, string, exception);
        }
        SecurityGroup securityGroup = new SecurityGroup((JdmBrowser)this, genModel);
        securityGroup.setIsInitiallyExpanded(false);
        this.tree.addEventListener((NavigationBrowserEventListener)securityGroup);
        navigationFolder.add((NavigationPoint)securityGroup);
    }

    private void buildToolsFolder(NavigationFolder navigationFolder) {
        NavigationContext navigationContext;
        NavigationItem navigationItem;
        Object object;
        ResourceBundle resourceBundle;
        String string = "buildToolsFolder";
        NavigationFolder navigationFolder2 = new NavigationFolder(this.resBundle.getString("tools"), new NavigationDestination("ibm.nways.jdm.NilDestination", null));
        navigationFolder.add((NavigationPoint)navigationFolder2);
        try {
            resourceBundle = ResourceBundle.getBundle("ibm.nways.telnet.TelnetPanelResources");
            object = new TelnetContext(this.ipAddress);
            navigationItem = new NavigationItem(resourceBundle.getString("TelnetPanelTitle"), new NavigationDestination("ibm.nways.telnet.TelnetPanel", null), "Telnet");
            navigationContext = navigationItem.getNavContext();
            navigationContext.put((Object)"telnetContext", object);
            navigationFolder2.add((NavigationPoint)navigationItem);
            if (this.getIsApplication()) {
                AnalyzerJdmContext analyzerJdmContext = new AnalyzerJdmContext(this.ipAddress, this.getServerPortNumber());
                NavigationItem navigationItem2 = new NavigationItem(AnalyzerJdmPanel.getTitle(), new NavigationDestination("ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel", null), "Analyzer");
                navigationContext = navigationItem2.getNavContext();
                navigationContext.put((Object)"analyzerJdmContext", (Object)analyzerJdmContext);
                navigationFolder2.add((NavigationPoint)navigationItem2);
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 2, (Object)this, string, exception);
        }
        try {
            resourceBundle = new WebContext(this.ipAddress);
            object = ResourceBundle.getBundle("ibm.nways.web.Resources");
            if (this.is8265()) {
                resourceBundle.support_and_device();
            } else {
                resourceBundle.only_nhd_url();
            }
            navigationItem = new NavigationItem(object.getString("weblaunch"), new NavigationDestination("ibm.nways.web.WebBrowserPanel", null), "WebBrowser");
            navigationContext = navigationItem.getNavContext();
            navigationContext.put((Object)"webContext", (Object)resourceBundle);
            navigationFolder2.add((NavigationPoint)navigationItem);
        }
        catch (Exception exception) {
            RAS.logException(19, 2, (Object)this, string, exception);
        }
        try {
            resourceBundle = this.getNavigationBrowser();
            object = (SnmpContextModel)this.jdm8260Model.getComponent("_ContextInfo");
            navigationItem = new Browser(this.resBundle.getString("mibBrowser"), (JdmBrowser)this, (SnmpContextModel)object);
            resourceBundle.addEventListener((NavigationBrowserEventListener)navigationItem);
            navigationFolder2.add((NavigationPoint)navigationItem.getRootFolder());
            return;
        }
        catch (Exception exception) {
            RAS.logException(19, 2, (Object)this, string, exception);
            return;
        }
    }

    public int getHubModel() {
        String string;
        String string2 = "getHubModel";
        if (RAS.isEnabled(19, 2)) {
            RAS.enter(19, 2, (Object)this, string2);
        }
        this.sysOid = null;
        Jdm8260NicknameTable jdm8260NicknameTable = new Jdm8260NicknameTable();
        this.mibInfo.setModelAndNicknames(this.jdm8260Model, jdm8260NicknameTable);
        Serializable serializable = this.mibInfo.getVar("sysOid");
        if (serializable instanceof SpecialValue) {
            this.mibInfo.setErrorCode(1);
            if (RAS.isEnabled(19, 2)) {
                RAS.exit(19, 2, (Object)this, string2);
            }
            return -1;
        }
        this.sysOid = string = serializable.toString();
        if (RAS.isEnabled(19, 2)) {
            RAS.exit(19, 2, (Object)this, string2);
        }
        return Jdm8260SummaryInfo.modelFromSysOid(string);
    }

    public boolean is8265() {
        return this.hubType == 2;
    }

    public boolean is8260() {
        return this.hubType == 1;
    }

    public boolean is8250() {
        return this.hubType == 0;
    }

    public void navPointSelected(NavigationPoint navigationPoint) {
        String string = navigationPoint.getId();
        if (string != null) {
            if (string.equals("ibm.nways.atmSW.eui.SwitchToAtmViewPanel")) {
                ((Hub)this.hub).switchToAtmView();
                return;
            }
            if (string.equals("ibm.nways.atmSW.eui.SwitchToDeviceViewPanel")) {
                ((Hub)this.hub).switchToDeviceView();
                return;
            }
        }
        super.navPointSelected(navigationPoint);
        if (this.hub != null) {
            ((HubInfoLike)((Object)this.hub)).showNetwork(navigationPoint.getLabel());
        }
    }

    public static void addOverrides(NavFieldOverride navFieldOverride, Object[][] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            navFieldOverride.put(objectArray[n][0], objectArray[n][1]);
            ++n;
        }
    }
}

